<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>
        <?php echo $__env->yieldContent('title_prefix', config('adminlte.title_prefix', '')); ?>
        <?php echo $__env->yieldContent('title', config('adminlte.title', 'AdminLTE 3')); ?>
        <?php echo $__env->yieldContent('title_postfix', config('adminlte.title_postfix', '')); ?>
    </title>
    <?php if(! config('adminlte.enabled_laravel_mix')): ?>
    <link rel="stylesheet" href="<?php echo e(asset('vendor/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">

    <?php echo $__env->make('adminlte::plugins', ['type' => 'css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('adminlte_css_pre'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('vendor/adminlte/dist/css/adminlte.min.css')); ?>">

    <?php echo $__env->yieldContent('adminlte_css'); ?>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="<?php echo e(asset('css/main.css') . '?v=' . rand(99999,999999)); ?>">

    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
    <?php endif; ?>

    <?php echo $__env->yieldContent('meta_tags'); ?>

    <?php if(config('adminlte.use_ico_only')): ?>
    <link rel="shortcut icon" href="<?php echo e(asset('favicons/favicon.ico')); ?>" />
    <?php elseif(config('adminlte.use_full_favicon')): ?>
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('favicons/'. config('adminlte.name_favicon'))); ?>">
    <?php endif; ?>
</head>

<body class="<?php echo $__env->yieldContent('classes_body'); ?>" <?php echo $__env->yieldContent('body_data'); ?>>
    <div class="reload hide"></div>
    <?php echo $__env->yieldContent('body'); ?>

    <?php if(! config('adminlte.enabled_laravel_mix')): ?>
    <script src="<?php echo e(asset('vendor/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>

    <?php echo $__env->make('adminlte::plugins', ['type' => 'js'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('adminlte_js'); ?>
    <script>
        function togglePasswordVisibility(element) {
            var input = element.closest('.input-group').querySelector('input');
            if (input) { // Check if input is not null
                if (input.type === "password") {
                    input.type = "text";
                    element.classList.remove('fa-eye-slash');
                    element.classList.add('fa-eye');
                } else {
                    input.type = "password";
                    element.classList.remove('fa-eye');
                    element.classList.add('fa-eye-slash');
                }
            }
        }
    </script>
    <?php else: ?>
    <script src="<?php echo e(mix('js/app.js')); ?>"></script>
    <?php endif; ?>

</body>

</html><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/vendor/adminlte/master.blade.php ENDPATH**/ ?>