<?php $__env->startSection('title', 'Analytics | ' . Config::get('adminlte.title')); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Analytics</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('layouts.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Data</h3>
    </div>

    <div class="card-body">
        <div class="alert alert-info" role="alert">
            Analytic only displays data for "late time", "overtime", and "early check-out".
        </div>

        <!-- Filtering -->
        <div id="date_filter" class="form-inline">
            <Form action="" method="get" class="form-inline col-sm-12" autocomplete="off">
                <div class="form-group mb-2">
                    <label for="from"></label>
                    <div class="input-group">
                        <input type="text" name="from" class="form-control" id="from" placeholder="From Date" value="<?php echo e($param['from']); ?>">
                        <div class="input-group-append" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
                <div class="form-group mx-sm-3 mb-2">
                    <label for="to"></label>
                    <div class="input-group">
                        <input type="text" name="to" class="form-control" id="to" placeholder="To Date" value="<?php echo e($param['to']); ?>">
                        <div class="input-group-append" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary mb-2"><i class="fa fa-filter"></i> Filter</button>
            </form>
        </div>
        <hr>
        <!-- Filtering -->

        <div class="row" id="reportPage">
            <!-- Chart -->
            <div class="col-sm-12" style="width:100%;">
                <?php echo $analytic->render(); ?>

            </div>
            <!-- Chart -->
        </div>

        <div class="table-responsive datatables-margin-t45">
            <hr>
            <?php echo $html->table(['class' => 'table table-hover']); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/bootstrap-datepicker/css/bootstrap-datepicker.css')); ?>">
<link href="<?php echo e(asset('vendor/datatables/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('vendor/datatables-plugins/buttons/css/buttons.bootstrap4.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('js/main_index.js'). '?v=' . rand(99999,999999)); ?>"></script>

<script src="<?php echo e(asset('vendor/bootstrap-datepicker/js/bootstrap-datepicker.min.js')); ?>"></script>
<!--Data tables-->
<script src="<?php echo e(asset('vendor/datatables/buttons.server-side.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/jszip/jszip.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/pdfmake/pdfmake.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/pdfmake/vfs_fonts.js')); ?>"></script>

<script src="<?php echo e(asset('vendor/datatables-plugins/buttons/js/dataTables.buttons.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/buttons/js/buttons.flash.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/buttons/js/buttons.colVis.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/buttons/js/buttons.html5.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables-plugins/buttons/js/buttons.print.js')); ?>"></script>
<?php echo $html->scripts(); ?>

<script>
    $(document).ready(function() {

        $('#from, #to').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: 'TRUE',
            autoclose: true,
            changeMonth: true,
            changeYear: true
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/backend/analytics/index.blade.php ENDPATH**/ ?>