<!-- page title -->
<?php $__env->startSection('title', 'Create and Update Areas ' . Config::get('adminlte.title')); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Areas</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('layouts.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Add or Update</h3>
    </div>

    <?php echo e(html()->form('POST', route($data->form_action))->id('areaId')->attribute('autocomplete', 'off')->attribute('files', true)->open()); ?>

    <?php echo e(html()->hidden('id', $data->id)->id('id')); ?>


    <div class="card-body">

        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Name</strong>
            </div>
            <div class="col-sm-8 col-content">
                <?php echo e(html()->text('name', $data->name)->class('form-control')->required()); ?>

                <small class="form-text text-muted">
                    <i class="fa fa-question-circle" aria-hidden="true"></i> Area name. You can specified like Mal Bali Galeria
                </small>
            </div>
            <div class="col-sm-2 col-content">
                <button type="button" id="searchPlace" class="btn btn-outline-primary"><i class="fas fa-search"></i> Search</button>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Address</strong>
            </div>
            <div class="col-sm-10 col-content">
                <?php echo e(html()->text('address', $data->address)->class('form-control')->id('address')->required()); ?>

                <small class="form-text text-muted">
                    <i class="fa fa-question-circle" aria-hidden="true"></i> Area address.
                </small>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Draw Area</strong>
            </div>
            <div class="col-sm-10 col-content">
                <div class="button-map">
                    <button type="button" id="draw" class="btn btn-outline-primary"><i class="fas fa-draw-polygon"></i> Draw</button>
                    <button type="button" id="clear" class="btn btn-outline-warning"><i class="fas fa-eraser"></i> Clear Area</button>
                    <button type="button" id="stopDraw" class="btn btn-outline-danger"><i class="far fa-stop-circle"></i> Stop Draw</button>
                </div>

                <div id="map-canvas"></div>
                <textarea id="info" class="hide"></textarea>
            </div>
        </div>
    </div>

    <div class="card-footer">
        <div id="form-button">
            <div class="col-sm-12 text-center top20">
                <button id="saveLocation" type="button" class="btn btn-primary"><?php echo e($data->button_text); ?></button>
            </div>
        </div>

        <small class="form-text text-center text-muted">
            <i class="fa fa-question-circle" aria-hidden="true"></i> The more polygon points, the longer the process of storing data to the database.
        </small>
    </div>
    <?php echo e(html()->form()->close()); ?>

</div>

<!-- /.card -->
</div>
<!-- /.row -->
<!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/ol@v8.2.0/ol.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var typePage = "<?php echo e($data->page_type); ?>";
</script>





<script src="https://cdn.jsdelivr.net/npm/ol@v8.2.0/dist/ol.js"></script>
<script src="<?php echo e(asset('js/backend/areas/form.js'). '?v=' . rand(99999,999999)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/backend/areas/form.blade.php ENDPATH**/ ?>